/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.ui.internal.quickfix.QuickFixKernelAssistant;

public class GNATbenchAnnotationImageProvider implements
		IAnnotationImageProvider {

	final static private String QUICKFIX_WARNING = "icon_quickfix_warning";
	final static private String QUICKFIX_ERROR = "icon_quickfix_error";

	final static private String QUICKFIX_ERROR_IMG = "quickfix_error_obj.gif";
	final static private String QUICKFIX_WARNING_IMG = "quickfix_warning_obj.gif";

	public GNATbenchAnnotationImageProvider () {
		if (GNATbenchUIPlugin.getDefault().getImage(QUICKFIX_ERROR) == null) {
			GNATbenchUIPlugin.getDefault().addImage(QUICKFIX_WARNING, "/img/",
					QUICKFIX_WARNING_IMG);
			GNATbenchUIPlugin.getDefault().addImage(QUICKFIX_ERROR, "/img/",
					QUICKFIX_ERROR_IMG);
		}
	}

	public ImageDescriptor getImageDescriptor(String imageDescritporId) {
		return null;
	}

	public String getImageDescriptorId(Annotation annotation) {
		return null;
	}

	public Image getManagedImage(Annotation annotation) {
		if (annotation instanceof SimpleMarkerAnnotation) {
			SimpleMarkerAnnotation simpleAnnot = (SimpleMarkerAnnotation) annotation;

			IMarker marker = simpleAnnot.getMarker();

			try {
				if (!marker.exists()
						|| !marker
								.isSubtypeOf(GNATbenchCorePlugin.ADA_ERROR_MARKER)) {
					return null;
				}
			} catch (CoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);

				return null;
			}

			GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
					.getDefault().getOrLoadRegistry(
							marker.getResource().getProject());
			QuickFixKernelAssistant fixKernel = (QuickFixKernelAssistant) registry
					.getAssistant(QuickFixKernelAssistant.ASSISTANT_ID);

			if (registry == null || !registry.isValid()
					|| !fixKernel.isFixable(marker)) {
				return null;
			}

			switch (marker.getAttribute(IMarker.SEVERITY, IMarker.SEVERITY_INFO)) {
				case IMarker.SEVERITY_ERROR:
					return GNATbenchUIPlugin.getDefault().getImage(QUICKFIX_ERROR);
				case IMarker.SEVERITY_WARNING:
					return GNATbenchUIPlugin.getDefault().getImage(QUICKFIX_WARNING);
			}
		}

		return null;
	}

}
