/*******************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.startup;

import java.io.IOException;

import org.eclipse.ui.IStartup;

/**
 * The purpose of this class is to set GNATbench properties on which the
 * plugins may depend on before the actual load of the plugins.
 */
public class Startup implements IStartup {

	public static final String SPARK_FOUND_PROPERTY =
		"com.adacore.gnatbench.spark.found";

	public void earlyStartup() {
		try {
			Runtime.getRuntime().exec("spark");
			System.setProperty(SPARK_FOUND_PROPERTY, "TRUE");
		} catch (IOException e) {
			System.setProperty(SPARK_FOUND_PROPERTY, "FALSE");

			return;
		}
	}

}
