/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Map.Entry;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IProgressMonitor;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;
import com.adacore.gnatbench.core.projects.IGNATProjectView;
import com.adacore.gnatbench.spark.SPARKToolChain;
import com.adacore.gnatbench.spark.SPARKToolMessage;

/**
 * This class manages the command for the simplifier
 * spadesimp
 * @author ceol
 */
public class SimplifyFilesJob extends CommandFilesJob {

	private final static String name = "SPARK simplifier";

	public SimplifyFilesJob(IFileStore[] resources) {
		super(name, SPARKToolMessage.class, resources, true);
	} // ctor

	@Override
	public void run(TreeMap<IGNATProjectView, LinkedList<IFileStore>> files,
			IProgressMonitor monitor) {
		final String command = "spadesimp";

		for (Entry<IGNATProjectView, LinkedList<IFileStore>> entry : files
				.entrySet()) {

			LinkedList <String> prjCommand = new LinkedList<String> ();
			prjCommand.add(command);

			final String[] switches = SPARKToolChain.getSPARKAttribute(entry.getKey().getEclipseProject(),
					"Default_Switches", "IDE", "simplifier");
			if (switches == null){
				continue;
			}

			// add the switches
			for (int j = 0; j < switches.length; j++) {
				prjCommand.add(switches[j]);
			}

			// add the files for the current project
			for (IFileStore store : entry.getValue()) {
				prjCommand.add(URIUtil.toPath(store.toURI()).toOSString());
			}

			try {
				runProcessInEnv((GPRProject)entry.getKey(), "SPARK Simplifier",
						prjCommand.toArray(new String[prjCommand.size()]), entry
								.getKey().getProjectFile().getParent(), monitor);
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}


} // SimplifyFilesJob
