/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Map.Entry;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;
import com.adacore.gnatbench.core.projects.IGNATProjectView;
import com.adacore.gnatbench.spark.SPARKToolChain;
import com.adacore.gnatbench.spark.SPARKToolMessage;

/**
 * This class manages the command for the SPARKSimp
 * @author ceol
 *
 */
public class SPARKSimpJob extends CommandFilesJob {

	private final static String name = "SPARK simplifier";

	public SPARKSimpJob(IFileStore[] resources) {
		super(name, SPARKToolMessage.class, resources, true);
	} // ctor

	/**
	 * @return the output_directory specified in the project file,
	 * or null
	 */
	protected IFileStore getWorkingDir(IProject project){
		// Get the output_directory value where the VCs might be located
		String[] switches = SPARKToolChain.getSPARKAttribute(project, "Default_Switches", "IDE", "Examiner");
		for (int j=0; j < switches.length; j++){
			if (switches[j].startsWith("output_directory=", 1)){
				try {
				 return GNATbenchCorePlugin.getDefault().getEFSRegistry()
							.getUniqueStore(URIUtil.toURI(switches[j].substring(18)));
				} catch (GNATbenchCoreException e) {
					GNATbenchCorePlugin.getDefault().logError(null, e);
					return null;
				}
			}
		}

		return null;
	}

	@Override
	public void run(TreeMap<IGNATProjectView, LinkedList<IFileStore>> files,
			IProgressMonitor monitor) {
		final String command = "sparksimp";

		for (Entry<IGNATProjectView, LinkedList<IFileStore>> entry : files
				.entrySet()) {

			LinkedList <String> prjCommand = new LinkedList<String> ();
			prjCommand.add(command);

			String [] spadesimpSwitches = SPARKToolChain.getSPARKAttribute(
					entry.getKey().getEclipseProject(), "Default_Switches", "IDE", "Simplifier");
			String [] sparksimpSwitches = SPARKToolChain.getSPARKAttribute(
					entry.getKey().getEclipseProject(), "Default_Switches", "IDE", "SPARKSimp");
			if (spadesimpSwitches == null || sparksimpSwitches == null){
				continue;
			}

			// add the switches
			for (int j = 0; j < sparksimpSwitches.length; j++) {
				prjCommand.add(sparksimpSwitches[j]);
			}

			// add SpadeSimp switches
			if (spadesimpSwitches.length > 0){
				prjCommand.add("-sargs");
				// add the switches of spadesimp
				for (int j= 0; j < spadesimpSwitches.length; j++) {
						prjCommand.add(sparksimpSwitches [j]);
					}
			}

			try {
				runProcessInEnv((GPRProject)entry.getKey(), "SPARKFormat",
						prjCommand.toArray(new String[prjCommand.size()]), entry
								.getKey().getProjectFile().getParent(), monitor);
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}


} // SPARKSimpJob
