/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Map.Entry;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;
import com.adacore.gnatbench.core.projects.IGNATProjectView;
import com.adacore.gnatbench.spark.SPARKToolChain;
import com.adacore.gnatbench.spark.SPARKToolMessage;

/**
 * This class manages the commands for SPARKmake
 *
 */
public class SPARKMakeJob extends CommandFilesJob {

	final private static String name = "SPARKmake";

	public SPARKMakeJob(IFileStore resources) {
		super(name, SPARKToolMessage.class, resources, true);
	} // ctor

	@Override
	public void run(TreeMap<IGNATProjectView, LinkedList<IFileStore>> files,
			IProgressMonitor monitor) {
		final String command = "sparkmake";

		for (Entry<IGNATProjectView, LinkedList<IFileStore>> entry : files
				.entrySet()) {

			LinkedList <String> prjCommand = new LinkedList<String> ();
			prjCommand.add(command);

			final String[] switches = SPARKToolChain.getSPARKAttribute(entry.getKey().getEclipseProject(),
					"Default_Switches", "IDE", "SPARKmake");
			//get the sources directories which can be added by union using "di="
			LinkedList<String> sources = SPARKToolChain.getSourceDirectories(entry.getKey().getEclipseProject());
			if (switches == null || sources == null){
				continue;
			}

			// add the switches
			for (int j = 0; j < switches.length; j++) {
				prjCommand.add(switches[j]);
			}

			// add the sources folders
			for (int j = 0; j < sources.size(); j++) {
				prjCommand.add("-di=" + sources.get(j));
			}

			//we do not add files as sparkmake apply to a project

			try {
				runProcessInEnv((GPRProject)entry.getKey(), "SPARKmake",
						prjCommand.toArray(new String[prjCommand.size()]), entry
								.getKey().getProjectFile().getParent(), monitor);
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}


} // SPARKMakeJob
