/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCoree
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;
import com.adacore.gnatbench.spark.GNATbenchSPARKPlugin;


/**
 * This action compiles a single file and computes the output.
 *
 * @author ceol
 *
 */
public class POGSAction implements IWorkbenchWindowActionDelegate {

	private ISelection fSelection;

	public void run(IAction action) {
		final IStructuredSelection selection = (IStructuredSelection) fSelection;
		final IFileStore[] resources = CommandFilesJob.selectionToIFileStore(selection.toArray());
		IFileStore resource;

		if (!selection.isEmpty()){
			// Only one selection for ExamineMetaFile
			resource = resources [0];
		} else return;

		// get the project associated with the project file
		// if the selected gpr file is not the project file,
		// an error message is displayed
		try {
				IProject project = null;
				if (resource.getName().endsWith(GNATbenchSPARKPlugin.PROJECT_EXTENSION)){
					 if ((project = GPRProject.getEclipseProjectForGPRPath(URIUtil.toPath(resource.toURI()).toOSString())) != null){
						resource = GNATbenchCorePlugin.getDefault()
						               	.getEFSRegistry().getUniqueStore(project.getLocationURI());
						} else {
							MessageDialog.openError(null, "SPARKmake", "The selected file is not the associated project file");
							return;
						}
				}
	} catch (CoreException e) {
		GNATbenchCorePlugin.getDefault().logError(null, e);
	} catch (GNATbenchCoreException e) {
		GNATbenchCorePlugin.getDefault().logError(null, e);
	}

		new POGSJob (resources[0]).schedule();
	}

	public void selectionChanged(IAction action, ISelection selection) {
		fSelection = selection;
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {}
	public void dispose() {}
	public void init(IWorkbenchWindow window) {}
}
