/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.builder.BuildConsole;
import com.adacore.gnatbench.core.internal.builder.BuildConsoleManager;
import com.adacore.gnatbench.core.internal.utils.ViewUtils;

public class HelpAction implements IWorkbenchWindowActionDelegate{

	private static final String HELP_COMMAND_UNIX = "spark -help";

	public void run(IAction action) {
		try {
			String input = "";
			Process HelpProcess = null;
			BuildConsole console = BuildConsoleManager.findConsole("Spark Console");

			try {
				HelpProcess = Runtime.getRuntime().exec(HELP_COMMAND_UNIX);
				// An exception has been raised which is probably because the
				// command hasn't been found
			} catch (Exception e) {
				GNATbenchCorePlugin.getDefault().logError("Runtime exception occured while launching SPARK command (SPARK not in PATH?)", e);
				throw new RuntimeException(	"Runtime exception occured while launching SPARK command");
			}

			// wait one second before printing the output of the help
			GNATbenchCorePlugin.getDefault().timedProcess(HelpProcess, 1000);

			BufferedReader stdInput = new BufferedReader(new InputStreamReader(
					HelpProcess.getInputStream()));
			while ((input = stdInput.readLine()) != null) {
				console.print(input + "\n");
			}

			ViewUtils.showConsoleView();

		} catch (IOException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} catch (Exception e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
