/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.filesystem.FileStoreRegistry;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;
import com.adacore.gnatbench.spark.GNATbenchSPARKPlugin;
import com.adacore.gnatbench.spark.SPARKToolChain;

/**
 * This action respond to the selection of a metafile,
 * a project file or a project for the SPARK examiner
 *
 */
public class ExamineMetaFileAction implements IWorkbenchWindowActionDelegate {

	ISelection fSelection;
	final static String META_EXTENSION = ".smf";

	public void run(IAction action) {
		final IStructuredSelection selection = (IStructuredSelection) fSelection;
		final IFileStore[] resources = CommandFilesJob.selectionToIFileStore(selection.toArray());
		IFileStore resource;

		if (!selection.isEmpty()){
			// Only one selection for ExamineMetaFile
			resource = resources [0];
		} else return;

		// get the project associated with the project file
		// if the selected gpr file is not the project file,
		// an error message is displayed
		try {
				IProject project = null;
				if (resource.getName().endsWith(GNATbenchSPARKPlugin.PROJECT_EXTENSION)){
					 if ((project = GPRProject.getEclipseProjectForGPRPath(URIUtil.toPath(resource.toURI()).toOSString())) != null){
						resource = GNATbenchCorePlugin.getDefault()
						               	.getEFSRegistry().getUniqueStore(project.getLocationURI());
						} else {
							MessageDialog.openError(null, "SPARKmake", "The selected file is not the associated project file");
							return;
						}
				}
		} catch (CoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

		// we look for the associated metafile
		// the switch can be 'filename' or 'filename.extension'
		if (resource.fetchInfo().isDirectory() ){
			String metaFileName = "spark" + META_EXTENSION;
			final String [] switches = SPARKToolChain.getSPARKAttribute(FileStoreRegistry.getDefaultProject(resource), "Default_Switches", "IDE", "SPARKmake");
			for (int j = 0; j < switches.length; j ++){
				// check if the user as set a specific meta filename
				if (switches[j].startsWith("-m=")){
					metaFileName = switches[j].substring(3, switches[j].length());
					if (! metaFileName.contains(".")){
						metaFileName += META_EXTENSION;
					}
				}

			}
			resource = resource.getChild(metaFileName);
		}

		new ExamineFilesJob(resource, true).schedule();
	}

	public void selectionChanged(IAction action, ISelection selection) {
		fSelection = selection;
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}
}
