/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.tools;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Map.Entry;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;
import com.adacore.gnatbench.core.projects.IGNATProjectView;
import com.adacore.gnatbench.spark.SPARKToolChain;
import com.adacore.gnatbench.spark.SPARKToolMessage;

/**
 * This class manages the command for the spark examiner
 */
public class ExamineFilesJob extends CommandFilesJob {

	final private static String name = "SPARK Examiner";
	private boolean metafile;

	public ExamineFilesJob(IFileStore[] resources, boolean metafile) {
		super(name, SPARKToolMessage.class, resources, true);
		this.metafile = metafile;
	} // ctor

	public ExamineFilesJob(IFileStore resources, boolean metafile) {
		super(name, SPARKToolMessage.class, resources, true);
		this.metafile = metafile;
	} // ctor

	@Override
	public void run(TreeMap<IGNATProjectView, LinkedList<IFileStore>> files,
			IProgressMonitor monitor) {
		boolean output_set = false;
		final String command = "spark";


		for (Entry<IGNATProjectView, LinkedList<IFileStore>> entry : files
				.entrySet()) {

			LinkedList <String> prjCommand = new LinkedList<String> ();
			prjCommand.add(command);

			final String[] switches = SPARKToolChain.getSPARKAttribute(entry.getKey().getEclipseProject(),
					"Default_Switches", "IDE", "examiner");
			if (switches == null){
				continue;
			}

			// add the switches and check if the output_directory is set
			for (int j = 0; j < switches.length; j++) {
				prjCommand.add(switches[j]);
				if (switches[j].startsWith("-ou")) {
					output_set = true;
				}
			}

			if (false == output_set){
				IFileStore folder = SPARKToolChain.getProjectOutputDirectory(entry.getKey().getEclipseProject());
				if (folder != null){
					prjCommand.add("-ou=" + URIUtil.toPath(folder.toURI()).toOSString());
				}
			}

			// use -brief, to get conform output
			prjCommand.add("-brief");

			//if the selection is a metafile
			// spark switches -brief @filename
			if (metafile){
				// check if the metafile does exists
				if (!entry.getValue().getFirst().fetchInfo().exists()){				//	IWorkbench workbench = PlatformUI.getWorkbench();
					//	MessageDialog.openError(workbench.getActiveWorkbenchWindow().getShell(), );
					Display.getDefault().asyncExec(new Runnable() {
		 				public void run() {
		 					MessageDialog
									.openError(
											null,
											"Examine project",
											"The SPARK metafile cannot be found, "
											+ "please examine the project by "
											+ " selecting the associated metafile");
		 				}
		 			});

					return;
				} else {
					prjCommand.add("@" + URIUtil.toPath(entry.getValue().getFirst().toURI()).toOSString());
				}
			}
			else{
				// add the files for the current project
					for (IFileStore store : entry.getValue()) {
						prjCommand.add(URIUtil.toPath(store.toURI())
								.toOSString());
					}
			}

			try {
				runProcessInEnv((GPRProject)entry.getKey(), "SPARK Examiner",
						prjCommand.toArray(new String[prjCommand.size()]), entry
								.getKey().getProjectFile().getParent(), monitor);
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}



} // ExamineFilesJob
