/*******************************************************************************
 * Copyright (C) 2008-2009 AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.pogs;

import java.util.Map;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class SumViewerConfiguration extends TextSourceViewerConfiguration {

    private SumEditor fEditor;

    public SumViewerConfiguration (SumEditor editor) {
    	super (editor.getPreferenceStorePublic());

       fEditor = editor;
    }


   /**
    * link the editor to the Hyperlinks
    */
	@Override
	protected Map <Object, Object> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
		Map <Object, Object> targets= super.getHyperlinkDetectorTargets(sourceViewer);
		targets.put("com.adacore.gnatbench.spark.pogs", fEditor); //$NON-NLS-1$
		return targets;
	}
}
