/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.spark.pogs;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

/**
 * This class create an Hyperlink for the SumEditor
 * @author ceol
 *
 */
public class SumHyperlinkDetector extends AbstractHyperlinkDetector {

	public IHyperlink[] detectHyperlinks(ITextViewer textViewer,
			IRegion region, boolean canShowMultipleHyperlinks) {
		SumEditor editor = (SumEditor) getAdapter(SumEditor.class);
		SumEntity entity = null;

		try {
			IRegion area = editor.getDocument().getLineInformationOfOffset(region.getOffset());
			entity = new SumEntity(area, editor.getFile());
		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

		if (entity == null  || !entity.isRegularIdentifier()) {
			return null;
		} else {
			return new IHyperlink[] { new SumHyperlink(entity) };
		}
	}
}

