/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.spark.pogs;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;

public class SumHyperlink implements IHyperlink {

	private SumEntity fEntity;

	public SumHyperlink (final SumEntity ref) {
		fEntity = ref;
	}

	public IRegion getHyperlinkRegion() {
		return fEntity.getRegion();
	}

	public String getHyperlinkText() {
		return fEntity.getName();
	}

	public String getTypeLabel() {
		return fEntity.getName();
	}

	/**
	 * Open the vcg file and move the cursor to the
	 * requested vc if it is known
	 */
	public void open() {
		IFileStore fileStore = null;
		try {
			fileStore =
				GNATbenchCorePlugin.getDefault().getEFSRegistry ().getUniqueStore(
						URIUtil.toURI(fEntity.getFile()));
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

	    try {
	    	// open the editor on the vcg file
	    	IEditorPart part = IDE.openEditorOnFileStore(
	    			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(),
	    			fileStore );
	    	GeneralizedFile genFile = GeneralizedFile.fromEditorInput(part.getEditorInput());

	    	//if we know which vc is concerned, let's reveal it in the editor
	    	if (fEntity.getVCNumber() != "0"){
	        	FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(genFile.getDocument());
	        	IRegion region = null;

	        	try {
					// find the vc and move the editor to the corresponding line
	           		region = finder.find(0, fEntity.getName()+"_"+fEntity.getVCNumber(), true, false, false, false);
					if (region != null){
						region = genFile.getDocument().getLineInformationOfOffset(region.getOffset());
						if (part instanceof ITextEditor){
							((ITextEditor)part).selectAndReveal(region.getOffset(), region.getLength());
						}
					}
	           	} catch (BadLocationException e) {
	           		GNATbenchCorePlugin.getDefault().logError(null, e);
				}

	    	}
	    } catch ( PartInitException e ) {
	    	GNATbenchCorePlugin.getDefault().logError(null, e);
	    }
	}


}
