/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.pogs;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;

/**
 * This class hold a reference to an entity of a pertinent line
 * in a sum file.
 * This line can be a reference to a VC, the path of the vcg file
 * or the name of the procedure
 */
public class SumEntity {

	//Region for the hyperlink
	private IRegion fRegion;
	//Name of the function/procedure
	private String fName;
	//File containing the procedure
	private String fFile;
	//The VC number
	private String fVC = "0";
	// the document
	private IDocument fDoc;


	public SumEntity(final IRegion region, final GeneralizedFile file){
		fDoc = file.getDocument();
		try{
			fRegion = fDoc.getLineInformationOfOffset(region.getOffset());
			String line = fDoc.get(fRegion.getOffset(), fRegion.getLength());

			// The line selected contains Package_Name.Procedure_Name
			if (line.indexOf("procedure") == 0 || line.indexOf("function") == 0){
				int lineNb = fDoc.getLineOfOffset(region.getOffset()) -1;
				setFromLine(lineNb);
				return;
			}
			// The line selected contains File File_Path_and_Name
			if (line.indexOf("File") == 0){
				setFromLine(fDoc.getLineOfOffset(region.getOffset()));
				return;
			}

			// The line selected is a reference to a vc
			int lineNumber = fDoc.getLineOfOffset(region.getOffset());
			IRegion  lineRegion = null;
			String tmp = new String();
			if (line.indexOf(" YES ") != -1){
				// the VC number is the first element on the line
				fVC = line.substring(0, line.indexOf('|')).trim();

				while (tmp.indexOf("File") != 0 && lineNumber > 6){
					lineRegion = fDoc.getLineInformation(--lineNumber);
					tmp = fDoc.get(lineRegion.getOffset(), lineRegion.getLength());
  				}

				setFromLine(lineNumber);


			}

		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}



	}

	public boolean isRegularIdentifier(){
		return fName!= null;
	}

	/**
	 * Set the SumEntity's member's value
	 * @param line the path to the vc file
	 * @param lineRegion the region of thi line
	 * @param lineNumber it's line number
	 * @param file
	 */
 	private void setFromLine(final int lineNumber){
		IRegion region = null;
		String line = null;
		try {
			region = fDoc.getLineInformation(lineNumber);
			line = fDoc.get(region.getOffset(), region.getLength());
		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null,e);
			return;
		}
		if (line.indexOf("File") == 0){
			// Get the vcg path
			fFile = line.substring(5);
			try {
				region = fDoc.getLineInformation(lineNumber +1);
				// Get the name of the procedure/function
				fName = fDoc.get(region.getOffset(), region.getLength());
				fName = fName.substring(fName.indexOf('.') + 1, fName.length());
			} catch (BadLocationException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
 	}


	/**
	 *
	 * @return The name of the entity.
	 */
	public String getName() {
		return fName;
	}

	/**
	 *
	 * @return The location of the entity.
	 */
	public IRegion getRegion() {
		return fRegion;
	}

	/**
	 *
	 * @return The path of the target file.
	 */
	public String getFile() {
		return fFile;
	}

	/**
	 *
	 * @return The VC's number
	 */
	public String getVCNumber() {
		return fVC;
	}

}