/*******************************************************************************
 * Copyright (c) 2005, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark.pogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;

/**
 * This is an read-only editor for sum files generated by the SPARK POGS
 * command. 
 */
public class SumEditor extends TextEditor{
	
	private SourceViewer fViewer = null;
	private GeneralizedFile fFile;
	private IDocument fDocument = null;
	
	
	/**
	 * Creates a new AdaEditor.
	 */
	public SumEditor() {
	}
	
	public GeneralizedFile getFile() {
		return fFile;
	}
	
	public IDocument getDocument () {
		return fDocument;
	}

	/**
	 * This function is the concrete constructor of the ada editor.
	 */
	protected void initializeEditor() {
		super.initializeEditor();
		
		setSourceViewerConfiguration(new SumViewerConfiguration(this));
	}
	
	@Override
	public boolean isEditable(){
		return false;
	}

	/**
	 * Creates the source viewer, and initialize some event-aware object on it.
	 */
	protected ISourceViewer createSourceViewer(Composite parent,
			IVerticalRuler ruler, int styles) {

		fViewer = new SourceViewer(parent, ruler,
					getOverviewRuler(), isOverviewRulerVisible(), styles);
		
		return fViewer;
	}
	
	
	/*
	 * @see org.eclipse.ui.texteditor.AbstractTextEditor#editorContextMenuAboutToShow(org.eclipse.jface.action.IMenuManager)
	 * @since 3.0
	 */
	@Override
	protected void editorContextMenuAboutToShow(IMenuManager menu) {
		super.editorContextMenuAboutToShow(menu);
	}
	
	IPreferenceStore getPreferenceStorePublic () {
		return super.getPreferenceStore();
	}
	
	public void doSetInput(IEditorInput input) throws CoreException {
		super.doSetInput(input);
		
		fFile = GeneralizedFile.fromEditorInput(input);
		GNATbenchCorePlugin.getDefault().removeBuffer(fFile);		
		fDocument = fFile.getDocument();
	}
	
	public IDocumentProvider getDocumentProvider() {
		return GNATbenchCorePlugin.getDefault().getDocumentProvider();
	}

}
