/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.internal.analyzer.Column;
import com.adacore.gnatbench.core.internal.jobs.ToolMessage;

/**
 * Parse the messages specific to SPARK
 *
 */
public class SPARKToolMessage extends ToolMessage{

	//the default message format
	final private static String MESSAGE_FORMAT = "(.*?):([0-9]+):([0-9]+): *(.* Error)?(Warning)? *[0-9]+ -(.*)";
	final public static Pattern MESSAGE_PATTERN = Pattern.compile (MESSAGE_FORMAT, Pattern.CASE_INSENSITIVE);

	public SPARKToolMessage (String message, IProject project) {
		super(message, project);
	} // SPARKToolMessage

	@Override
	public ParseResult parse() {
		Matcher match = MESSAGE_PATTERN.matcher(getMessage());

		if (!match.matches()) {
			return null;
		}

		ParseResult result = new ParseResult ();

		final String [] nameParts = match.group(1).split(":");

	    if (nameParts.length < 3) {
			result.fileName = match.group(1);
	    } else {
	    	final int last = nameParts.length - 1;
	    	result.fileName = nameParts[last - 1] + ":" + nameParts[last];
	    	// b~basic.o:F:/path/to/b~basic.adb:122: undefined reference to `__gcov_init'
		} // if

	    result.line = Integer.parseInt(match.group(2));
	    result.column = new Column((match.group(3) != null ? Integer
				.parseInt(match.group(3)) : 1), Column.DEFAULT_GNAT_TAB_WIDTH);
	    boolean error = match.group(4) != null;

	    result.caption = error ? match.group(4) + ": " + match.group(6).trim()
				: match.group(6).trim();

	    if (match.group(5) != null) {
	    	result.severety = IMarker.SEVERITY_WARNING;
	    } else {
	    	result.severety = IMarker.SEVERITY_ERROR;
	    }

	    result.markerType = GNATbenchSPARKPlugin.SPARK_ERROR_MARKER;

		return result;
	}


} // SPARKToolMessage
