/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark;

import java.util.LinkedList;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
public class SPARKToolChain {

	/**
	 * Return an array of String containing the switches
	 * @project
	 * @attributeName
	 * @packageName
	 * @indexName
	 */
	public static String[] getSPARKAttribute(final IProject project,
			String attributeName, String packageName, String indexName) {
		final GPRProject gprProject = ((GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project)).getGPRFor(project);
		String[] switches = null;

		try {
			switches = gprProject.getAttributeAsList(attributeName,	packageName, indexName);
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

		return switches;
	}

	/**
	 * Get the sources directories specified in the project file
	 * @project
	 * @return a LinkedList containing the sources directories
	 */
	public static LinkedList<String> getSourceDirectories(final IProject project) {
		final GPRProject gprProject = ((GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project)).getGPRFor(project);
		LinkedList<IFileStore> src = null;
		LinkedList<String> srcString = null;
		try {
			src = gprProject.getSourceDirectories(false);
			srcString = new LinkedList<String> ();

			for (int i = 0; i < src.size(); i++){
				srcString.add(URIUtil.toPath(src.get(i).toURI()).toOSString());
			}
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(e.getMessage(),e);
		}

		return srcString;
	}

	/**
	 * or the project output directory
	 * @param project
	 * @return the project output dir if set
	 *  or null
	 */
	public static IFileStore getProjectOutputDirectory(final IProject project){
		final GPRProject gprProject = ((GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project)).getGPRFor(project);
		LinkedList<IFileStore> outp = null;

		try {
				outp = gprProject.getObjectDirectories(false);
			} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(e.getMessage(),e);
		}

		if (outp != null && outp.size() > 0){
			return outp.getFirst();
		}

		return null;
	}

} // SPARKToolChain
