/*******************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark;

import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.internal.jobs.IMessageConstructor;
import com.adacore.gnatbench.core.internal.jobs.ToolMessage;

public class SPARKMessageConstructor implements IMessageConstructor {

	public ToolMessage create(String message,
			Class<? extends ToolMessage> messageClass, IProject project) {

		if (!SPARKToolMessage.class.isAssignableFrom(messageClass)) {
			return null;
		}

		if (SPARKToolMessage.MESSAGE_PATTERN.matcher (message).matches()) {
			return new SPARKToolMessage (message, project);
		}

		return null;
	}

}
