/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.spark;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

/**
 * The activator class controls the plug-in life cycle
 */
public class GNATbenchSPARKPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "com.adacore.gnatbench.spark";

	// Project file extension
	public static final String PROJECT_EXTENSION = ".gpr";

	// The shared instance
	private static GNATbenchSPARKPlugin plugin;

	public static final String SPARK_ERROR_MARKER =
		"com.adacore.gnatbench.spark.SPARKErrorMarker";

	public GNATbenchSPARKPlugin() {
	}//ctr

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;

		GNATbenchCorePlugin.getDefault().getMessageFactory()
				.registerMessageClass(new SPARKMessageConstructor());

		// Under linux, the spark commands are not complete if the stack size is limited
		if (Platform.getOS().equals("linux")){
			try {
				    ProcessBuilder pb = new ProcessBuilder("sh","-c", "ulimit -s");
				    Process ulimit = pb.start();
					BufferedReader stdInput = new BufferedReader(
							new InputStreamReader(ulimit.getInputStream()));

					// wait at most one second before printing the output of the help
					GNATbenchCorePlugin.getDefault().timedProcess(ulimit, 1000);
					String input = stdInput.readLine();

					if ( input != null && !input.equals("unlimited")) {
						MessageDialog.openError(null, "Stack issue", "The stack size seems to be to small ("
								+input
								+") for the spark tools, please consider to unlimit the stack size using ulimit -s unlimited");

					}
				} catch (IOException e) {
					GNATbenchCorePlugin.getDefault().logError(null, e);
				}
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static GNATbenchSPARKPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}


}
