package com.adacore.gnatbench.library;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "com.adacore.gps";

	// The shared instance
	private static Activator plugin;
	
	/**
	 * The constructor
	 */
	public Activator() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
	/**
	 * This native function call the elaboration of the ada library.
	 */
	private static native void libInitInt();	
	
	static {
		try {			
			com.adacore.ajis.AJISLibrary.preemptLoad();
			System.loadLibrary ("gnatbench"); 			
		    libInitInt();
		}
		catch (SecurityException e) {
			System.out.println ("SecurityException: " + e.getMessage());
		}
		catch (UnsatisfiedLinkError e) {
			System.out.println ("UnsatisfiedLinkError: " + e.getMessage ());
		}
		catch (Exception e) {
			System.out.println ("Exception: " + e);
		}
    }	

}
