/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.projects;

import java.util.LinkedList;

import com.adacore.gnatbench.core.GNATbenchCoreException;

/**
 * Implementer of this interface provide an access to a project's scenario 
 * variable.
 * 
 * This is not intended to be implemented by clients.
 * 
 * @since 2.2
 */
public interface IScenarioVariable {

	/**
	 * Return the list of possible values accepted by this variable, if such
	 * a list exist. Otherwise, an empty list will be returned.
	 */
	public LinkedList <String> getPossibleValues ();
	
	/**
	 * Return the current value for this variable.
	 */
	public String getValue ();
	
	/**
	 * Return the external name to which this scenario variable is connected 
	 * with.
	 */
	public String getExternalName ();
	
	/**
	 * Change the value of this scenario variable. If the value is not accepted
	 * by the possible values, then GNATbenchCoreException will get thrown.
	 */
	public void setValue (String value) throws GNATbenchCoreException;
	
}
