/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.projects;

/**
 * Instances of this interface are notified when certain events occures on the 
 * GNATbench kernel.
 * 
 * This interface is intended to be implemented by clients.
 * 
 * @since 2.2
 */
public interface IGNATProjectRegistryListener {
	
	/**
	 * Called after a registry recomputation.
	 */
	public void recomputed (IGNATProjectRegistry registry);

}
