/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.projects;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;

/**
 * Creates or retreives GNAT project registries.
 * 
 * This interface is not intented to be implemented by clients.
 * 
 * @since 2.2
 */
public interface IGNATProjectRegistryFactory {

	/**
	 * Return a GNATbench kernel corresponding to the project given in 
	 * parameter. If the project is a root project, then the associated kernel 
	 * will hold its project hierarchy. If not, the returned kernel is a kernel 
	 * containing a project hierarchy including this project.
	 */
	public IGNATProjectRegistry getOrLoadRegistry (IProject project);
	
	/**
	 * Create a registry after the path of a gpr file without linking it to 
	 * any IProject. A new registry will be created each time this function
	 * is called.
	 */
	public IGNATProjectRegistry createAnonymousRegistry (IFileStore file);
	
	public void addListener (IGNATProjectRegistryFactoryListener listener);
	
	public void removeListener (IGNATProjectRegistryFactoryListener listener);
	
}
