/*******************************************************************************
 * Copyright (c) 2007, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.projects;

/** 
 * This interface has to be implemented by clients to add capabilities to a 
 * project registry. The lifetime of the corresponding object is similar to the
 * one of the enclosing registry.
 * 
 * This interface is intended to be implemented by clients.
 *
 * @since 2.2
 */
public interface IGNATProjectRegistryAssistant {

	/**
	 * This function is called at the end of the registry first initialization.
	 */
	public void initialize (IGNATProjectRegistry registry);
	
	/**
	 * This function is called when the registry is ready to be destroyed.
	 */
	public void release (IGNATProjectRegistry registry);
	
}
