/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.projects;

/**
 * Instances of this interface represent a message coming from the GNAT project
 * explorer at load time.
 * 
 * This interface is not intended to be implemented by clients.
 * 
 * @since 2.2
 */
public interface IGNATProjectMessage {
	enum Kind {ERROR, WARNING, INFO}
	
	/**
	 * Return this kind of message.
	 */
	public Kind getKind ();
	
	/**
	 * Return the message, in the form file:line:column:message.
	 */
	public String getMessage ();
}
