/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.utils;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleConstants;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class ViewUtils {

	public static void showProblemsView() {
		PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
			public void run() {
				try {
					IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
					if (window != null) {
						IWorkbenchPage p = window.getActivePage();
						if (p != null) {
							p.showView("org.eclipse.ui.views.ProblemView");
						} // if
					} // if
				} catch (PartInitException e) {
					GNATbenchCorePlugin.getDefault().logError(null, e);
				} // try
			} // run
		});
	} // showProblemsView

	public static void showConsoleView() {
		PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
			public void run() {
				try {
					IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
					if (window != null) {
						IWorkbenchPage p = window.getActivePage();
						if (p != null) {
							p.showView(IConsoleConstants.ID_CONSOLE_VIEW, null, IWorkbenchPage.VIEW_VISIBLE);
						} // if
					} // if
				} catch (PartInitException e) {
					GNATbenchCorePlugin.getDefault().logError(null, e);
				} // try
			} // run
		});
	} // showConsoleView

} // ViewUtils
