/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.utils;

import java.util.LinkedList;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectView;

public class ProjectUtils {

	public static String specSuffixAda (final IProject project) {
		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project);

		if (registry != null && registry.isValid()) {
			final GPRProject gprProject = registry.getGPRFor(project);

			String specSuffix = null;
			try {
				specSuffix = gprProject.getAttributeValue("spec_suffix",
						"naming", "ada");
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			} // try
			if (specSuffix == null) {
				return ".ads";
			} // if
			return specSuffix;
		} else {
			return ".ads";
		}

	} // specSuffixAda


	public static String bodySuffixAda(final IProject project) {
		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
		.getDefault().getOrLoadRegistry(project);

		if (registry != null && registry.isValid()) {
			final GPRProject gprProject = registry.getGPRFor(project);
			String bodySuffix = null;
			try {
				bodySuffix = gprProject.getAttributeValue ("body_suffix", "naming", "ada");
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			} // try
			if (bodySuffix == null) {
				return ".adb";
			} // if
			return bodySuffix;
		} else {
			return ".adb";
		}
	} // bodySuffixAda


	/**
	 * @Deprecated Should use
	 * {@link GNATProjectRegistry#isManagedSourceFile(IResource)} instead
	 */
	public static boolean isAdaSourceFile(final IResource file, final IProject project) {
		return isAdaSourceFileName(file.getName(), project);
	} // isAdaSourceFile

	/**
	 * @Deprecated Should use
	 * {@link GNATProjectRegistry#isManagedSourceFile(IResource)} instead
	 */
	public static boolean isAdaSourceFileName (final String name, final IProject project) {
		// note that the Eclipse function getFileExtension() does not properly handle
		// extensions such as ".1.ada", in that it considers the ".1" to be part of the name.

		return (name.endsWith(specSuffixAda(project))) ||
		       (name.endsWith(bodySuffixAda(project)));
	} // isAdaSourceFileName


	public static boolean styleViolationsAreErrors(final IProject project) throws GNATbenchCoreException {
		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
		.getDefault().getOrLoadRegistry(project);

		if (registry != null && registry.isValid()) {
			String [] switches = registry.getRootProject()
			.getAttributeAsList("default_switches", "compiler", "ada");
			for (int k = 0; k < switches.length; k++) {
				if (switches[k].equals("-gnatwe")) {
					return true;
				} // if
			} // for
		}

		return false;
	} // styleViolationsAreErrors


	/**
	 * searches the root project and its dependencies for the specified
	 * attribute.  the attribute value is that of a single string.
	 *
	 * @param kernel
	 * @param attr
	 * @param pkg
	 * @param index
	 * @return
	 * @throws GNATbenchCoreException
	 */
	public static String getStringAttributeGlobally(
			final GNATProjectRegistry kernel,
			final String attr,
			final String pkg,
			final String index)
		throws GNATbenchCoreException
	{
		String result = null;
		final GPRProject gpr = kernel.getRootProject();
		final LinkedList <IGNATProjectView> deps = gpr.getDependencies(false);
		String extractedValue = gpr.getAttributeValue(attr, pkg, index);

		if (extractedValue != null && !extractedValue.equals("")) {
			return extractedValue;
		} // if

		for (IGNATProjectView view : deps) {
			extractedValue = ((GPRProject) view).getAttributeValue(attr, pkg,
					index);

			if (extractedValue != null && !extractedValue.equals("")) {
				if (result == null) {
					result = extractedValue;
				} else {
					// we already had a value so compare this new value for consistency
					if (!result.equals(extractedValue)) {
						final String toolchain1 = result;
						final String toolchain2 = extractedValue;
						throw new GNATbenchCoreException("Inconsistency between the"
								+ " toolchains "
								+ "\"" + toolchain1 + "\" and "
								+ "\"" + toolchain2 + "\" given by"
								+ " two different projects. ");
					} // if
				} // if
			} // if
		} // for

		return result;
	} // getStringAttributeGlobally

	/**
	 * Test if the gpr file has errors
	 * @param project
	 * @return return true the gpr file is invalid or can't be loaded
	 */
	public static boolean GPRHasErrors (IProject project){
		IGNATProjectRegistry registry = GNATbenchSession
			.getDefault().getProjectRegistryFactory().getOrLoadRegistry(project);
		return (! registry.isValid() || registry.getRootProject() == null);
	}



} // ProjectUtils
