/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.utils;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class PluginUtils {

	/**
	 * Looks for any WRS Workbench plug-in.
	 * Useful to determine whether this is the WRS Workbench version of
	 * GNATbench.
	 */
	public static boolean isWRSPluginPresent() {
	    final IExtensionRegistry er = Platform.getExtensionRegistry();
		final IExtensionPoint ep = er.getExtensionPoint("org.eclipse.ui", "newWizards");

		final IExtension[] extensions = ep.getExtensions();
		if (extensions.length == 0) {
			return false;
		} // if

		for (int k = 0; k < extensions.length; ++k) {
			try {
				final Bundle bundle = Platform.getBundle(extensions[k].getNamespaceIdentifier());
				if (bundle.getSymbolicName().toLowerCase().startsWith("com.windriver")) {
					return true;
				} // if
			} catch (InvalidRegistryObjectException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
				return false;
			} // try
		} // loop
		return false;
	} // isWRSPluginPresent

} // PluginUtils
