/*******************************************************************************
 * Copyright (C) 2006-2009 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.toolchain;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class ToolChain {

	public static class NoExtensionFound extends Exception {

		/**
		 *
		 */
		private static final long serialVersionUID = -6849879337029874404L;

	} // NoExtensionFound


	public static IGNATbenchToolChain active() throws NoExtensionFound {

	    IExtensionRegistry er = Platform.getExtensionRegistry();
		IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(),
				"toolchainDefinition");

		IExtension[] extensions = ep.getExtensions();

		if (extensions.length == 0) {
			throw new NoExtensionFound();
		} // if

		for (int extInd = 0; extInd < extensions.length; ++extInd) {

			IConfigurationElement[] elements = extensions[extInd].getConfigurationElements();

			for (int k = 0; k < elements.length; ++k) {
				if (elements[k].getName().equals("definition")) {
					try {
						Bundle bundle = Platform.getBundle(extensions[extInd]
								.getNamespaceIdentifier());

						IGNATbenchToolChain result  =
							(IGNATbenchToolChain) bundle
								.loadClass(
										elements[k]
												.getAttribute("class"))
								.newInstance();

						return result;

					} catch (InvalidRegistryObjectException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (InstantiationException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (IllegalAccessException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (ClassNotFoundException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} // try
				} // if
			} // loop
		} // loop
		return null;
	} // active

} // ToolChain
