/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.toolchain;

import org.eclipse.core.resources.IProject;

public interface IGNATbenchToolChain {
	
	/**
	 * @return the string to identify the toolchain.
	 * eg "gnatmake" 
	 */
	public String name (final IProject project);
	
	/**
	* @return the build command.
	* eg {"gnatmake", "-d"}
	*/	
	public String[] buildCommand (final IProject project);
	
	/**
	 * @return the gnatls command.
	 * eg {"gnatls", "-v"}
	 */
	public String[] gnatlsCommand (final IProject project);
	
	/**
	 * @return the compile command.
	 * eg {"gnatmake", "-c"}
	 */
	public String[] compileCommand (final IProject project);
		
} // IGNATbenchToolChain
