/*******************************************************************************
 * Copyright (c) 2006, 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class is used to ease preferences definitions for GNATbench, used with
 * the extensiton point com.adacore.gnatbench.core.preferences
 *
 */
public interface IGNATbenchPreferencesProvider {

	/**
	 * Sets the default values for the preferences
	 * 
	 * @param store Should always come from the Core plugin
	 */
	public void initializeDefaultPreferences (IPreferenceStore store);
	
	/**
	 * Called to create the preference fields
	 * 
	 * @param page
	 */
	public void createPreferenceFields(AdaPreferencePage page);
	
	/**
	 * Called when OK has been performed on the page.
	 * 
	 * @param page
	 */
	public void okPerformed (AdaPreferencePage page);
	
}
