/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

/**
 * Baseclass for all Ada preferences pages.
 *
 * @author ochem
 */
public abstract class AdaPreferencePage extends FieldEditorPreferencePage
		implements
			IWorkbenchPreferencePage {

	String fId;

	/**
	 * @param style
	 */
	protected AdaPreferencePage(int style, String id) {
		super(style);

		fId = id;
		setPreferenceStore(GNATbenchCorePlugin.getDefault()
				.getPreferenceStore());
	}

	public void addField(FieldEditor field) {
		super.addField(field);
	}

	public Composite getFieldEditorParent() {
		return super.getFieldEditorParent();
	}

	public String getId () {
		return fId;
	}

	public boolean performOk () {
		boolean result = super.performOk();

		IExtensionRegistry er = Platform.getExtensionRegistry();
		IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(),
				"preference");

		IExtension[] extensions = ep.getExtensions();

		for (int extInd = 0; extInd < extensions.length; ++extInd) {

			IConfigurationElement[] elements = extensions[extInd]
					.getConfigurationElements();

			for (int i = 0; i < elements.length; ++i) {
				if (elements[i].getName().equals("provider")) {
					try {
						Bundle bundle = Platform.getBundle(extensions[extInd]
								.getNamespaceIdentifier());

						String id = elements[i].getAttribute("pageId");

						if (id.equals(getId())) {
							IGNATbenchPreferencesProvider preferenceProvider =
								(IGNATbenchPreferencesProvider) bundle
									.loadClass(
											elements[i].getAttribute("class"))
									.newInstance();

							preferenceProvider.okPerformed(this);
						}
					} catch (InvalidRegistryObjectException e) {
						GNATbenchCorePlugin.getDefault().logError (null, e);
					} catch (InstantiationException e) {
						GNATbenchCorePlugin.getDefault().logError (null, e);
					} catch (IllegalAccessException e) {
						GNATbenchCorePlugin.getDefault().logError (null, e);
					} catch (ClassNotFoundException e) {
						GNATbenchCorePlugin.getDefault().logError (null, e);
					}
				}
			}
		}

		return result;
	}
}