/*******************************************************************************
 * Copyright (c) 2005, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/
package com.adacore.gnatbench.core.internal.make;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;

import com.adacore.gnatbench.core.internal.builder.GNATbenchCommandJob;
import com.adacore.gnatbench.core.internal.builder.GNATbenchIncrementalBuilder.JobCompleteAdapter;
import com.adacore.gnatbench.core.internal.jobs.GNATToolMessage;

public class MakefileTarget extends PlatformObject implements IMakefileTarget {

	protected IProject project;
	protected String   name;
	protected String   description;
	private final String commandsName = "Ada build";

	public MakefileTarget(IProject project, String name, String description) {
		this.project = project;
		this.name = name;
		this.description = description;
	} // ctor


	public String getDescription() {
		return description;
	} // getDescription


	public String getName() {
		return name;
	} // getName


	public boolean invoke(String [] args) {
		GNATbenchCommandJob job = getInvokeJob(args);

		job.schedule();
		job.addJobChangeListener(new JobCompleteAdapter(project));

		return true;
	} // invoke

	public GNATbenchCommandJob getInvokeJob (String [] args) {
		StringBuffer params = new StringBuffer("");
		if (args != null) {
			for (int k = 0; k < args.length; k++) {
				params.append(args[k] + " ");
			} // for

			final String[] command = new String[1 + args.length + 1];
			// command contains the command to launch, plus the args, plus name.

			command[0] = "make";

			for (int j = 0; j < args.length; j++)
				command [1 + j] = args[j];

			command [args.length + 1] = name;
			GNATbenchCommandJob job = new GNATbenchCommandJob(command, project,
					commandsName, GNATToolMessage.class, true);

			return job;

		} else {
			final String [] command = {"make", name};
			GNATbenchCommandJob job = new GNATbenchCommandJob(command, project,
					commandsName, GNATToolMessage.class, true);

			return job;
		}// if
	}


} // MakefileTarget
