/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.make;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class Makefile extends PlatformObject implements IMakefile {

	private IProject project;
	private Map<String, MakefileTarget> allTargets = new HashMap<String, MakefileTarget>();


	public Makefile(IProject project) {
		this.project = project;
		readFile(project.getFile(MAKEFILE_NAME));
	} // ctor


	public IMakefileTarget [] targets() {
		IMakefileTarget [] result = new IMakefileTarget[allTargets.size()];

		int k = 0;
		for (IMakefileTarget target : allTargets.values()) {
			result [k] = target;
			k++;
		} // for

		return result;
	} // targets


	public IMakefileTarget target(final String name) {
		if (allTargets.containsKey(name)) {
			return (IMakefileTarget) allTargets.get(name);
		} // if
		return null;
	} // target


	public IProject project() {
		return project;
	} // project


	// TODO:  really should compile these...
	static private final String rule = "^[a-zA-Z_0-9]*:.*$";
	static private final String comment = "#.*$";

	// read a makefile file into this object
	private void readFile(final IFile makefile) {

		final File file = new File(project.getLocation() + "/" + MAKEFILE_NAME);

		DataInputStream dis = null;

		try {
			StringBuffer description = new StringBuffer("");

			dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
			while (dis.available() != 0) {

				final String line = dis.readLine();

				// skip the commands associated with targets
				if (line.startsWith("\t")) {
					continue;
				} // if

				// we only want to use the comments immediately preceding a target
				if (line.equals("")) {
					description = new StringBuffer("");
					continue;
				} // if

				if (line.matches(comment)) {
					// ensure there is (only) one blank between any consecutive comment
					// lines since we are potentially making one big line out of several
					description.append(line.substring(1).trim() + " ");
					continue;
				} // if

				if (line.matches(rule)) {
					final int colonPos = line.indexOf(':');
					final String targetName = line.substring(0, colonPos);

					MakefileTarget target = new MakefileTarget(project, targetName, description.toString());
					allTargets.put(targetName, target);

					description = new StringBuffer("");
				} // if

			} // while

			dis.close();
		} catch (FileNotFoundException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} catch (IOException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try
	} // readFile


} // IMakefile
