/*****************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.jobs;

import java.util.HashSet;

import org.eclipse.core.resources.IProject;

/**
 * This class is used to store message constructors, and create instances
 * of messages.
 */
public class MessageFactory {

	private HashSet<IMessageConstructor> fConstructors = new HashSet<IMessageConstructor>();

	public MessageFactory () {
		fConstructors.add(new DefaultMessageConstructor ());
	}

	public void registerMessageClass (IMessageConstructor messageConstructor) {
		fConstructors.add(messageConstructor);
	}

	public ToolMessage parseMessage(String message,
			Class<? extends ToolMessage> messageClass, IProject project) {
		for (IMessageConstructor constructor : fConstructors) {
			ToolMessage toolMessage = constructor.create(message, messageClass,
					project);

			if (toolMessage != null) {
				return toolMessage;
			}
		}

		return null;
	}

}
