package com.adacore.gnatbench.core.internal.jobs;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class LaunchFailureMessage extends DefaultToolMessage {

	public LaunchFailureMessage(String message, IProject project) {
		super(message, project);
	}

	@Override
	public ParseResult parse() {
		ParseResult result = new ParseResult ();

		final String msg = getMessage();
		final String msgParts [];
		final String commandParts [];
		final String commandName;

		if (msg.contains("is not recognized")) {
			msgParts = msg.split("is not recognized");
			commandParts = msgParts[0].split("'");
			commandName = commandParts[1];
		} else {
			msgParts = msg.split(": ");
			commandName = "\"" + msgParts[1] + "\"";
			// Eg: "/usr/bin/sh: powerpc-elf-gnatmake: command not found"
		} // if

		result.caption = "The command " + commandName + " cannot be launched";
		result.severety = IMarker.SEVERITY_ERROR;
		result.markerType = GNATbenchCorePlugin.ADA_ERROR_MARKER;

		return result;
	}

}
