/*******************************************************************************
 * Copyright (c) 2007, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.jobs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.Column;

/**
 * Parse the messages specific to GNAT
 *
 */
public class GNATToolMessage extends DefaultToolMessage {

	//the default message format
	static final private String MESSAGE_FORMAT = "(.*?):([0-9]+)(:([0-9]+))?: (warning: )?(.*)";

	static final Pattern MESSAGE_PATTERN  =
		Pattern.compile(MESSAGE_FORMAT, Pattern.CASE_INSENSITIVE);

	public GNATToolMessage (String message, IProject project) {
		super(message, project);
	}

	@Override
	public ParseResult parse() {
		ParseResult result = new ParseResult ();

	    result.markerType = GNATbenchCorePlugin.ADA_ERROR_MARKER;

		Matcher match = MESSAGE_PATTERN.matcher(getMessage ());

		if (!match.matches()) {
			return null;
		}

		final String [] nameParts = match.group(1).split(":");

	    if (nameParts.length < 3) {
			result.fileName = match.group(1);
	    } else {
	    	final int last = nameParts.length - 1;
	    	result.fileName = nameParts[last - 1] + ":" + nameParts[last];
	    	// b~basic.o:F:/path/to/b~basic.adb:122: undefined reference to `__gcov_init'
		} // if

	    result.line = Integer.parseInt(match.group(2));
	    result.column = new Column((match.group(4) != null ? Integer
				.parseInt(match.group(4)) : 1), Column.DEFAULT_GNAT_TAB_WIDTH);

	    if (match.group(5) != null || getMessage().contains("(style)")) {
	    	result.severety = IMarker.SEVERITY_WARNING;
	    } else {
	    	result.severety = IMarker.SEVERITY_ERROR;
	    }

	    result.caption = match.group(6).trim();

	    return result;
	}

} // GNATToolMessage
