/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/
package com.adacore.gnatbench.core.internal.jobs;

import java.util.LinkedList;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.projects.IGNATProjectView;

public abstract class GNATFilesJob extends CommandFilesJob {

	public GNATFilesJob(IFileStore[] resources, boolean doAutoSave) {
		super("Ada build", GNATToolMessage.class, resources, doAutoSave);
	}

	public LinkedList <String> getCommonSuffix (IGNATProjectView project, LinkedList <IFileStore> resources) {
		LinkedList <String> result = new LinkedList <String> ();

		String gprFileLocation = "";
		try {
			gprFileLocation = URIUtil.toPath(project.getProjectFile().toURI()).toOSString();
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
			return null;
		}

		result.add("-P");
		result.add(gprFileLocation);

		for (IFileStore store : resources) {
			result.add(store.getName());
		}

		return result;
	}

} // GNATFilesJob
