/*******************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.jobs;

import org.eclipse.core.resources.IProject;

public class DefaultMessageConstructor implements IMessageConstructor {

	public ToolMessage create(String message,
			Class<? extends ToolMessage> messageClass, IProject project) {
		ToolMessage result;

		if (!DefaultToolMessage.class.isAssignableFrom(messageClass)) {
			return null;
		}

		if (message.contains("is not recognized as an internal or external command")
				|| message.contains("command not found")) {

		   result =  new LaunchFailureMessage (message, project);
		} else if (message.matches("^error: (.*)")) {

			result = new ProjectMessage (message, project);
		} else if (GNATToolMessage.MESSAGE_PATTERN.matcher(message).matches()) {

			result = new GNATToolMessage (message, project);
		} else if (GeneralToolMessage.MESSAGE_PATTERN.matcher(message).matches()) {

			result = new GeneralToolMessage (message, project);
		} else {
			return null;
		}

		return result;
	}

}
