/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.jobs;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Map.Entry;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.toolchain.ToolChain;
import com.adacore.gnatbench.core.internal.toolchain.ToolChain.NoExtensionFound;
import com.adacore.gnatbench.core.projects.IGNATProjectView;


public class CompileAdaFilesJob extends GNATFilesJob {

	public CompileAdaFilesJob(IFileStore[] resources, boolean doAutoSave) {
		super(resources, doAutoSave);
	} // ctor

	@Override
	public void run(TreeMap<IGNATProjectView, LinkedList<IFileStore>> files,
			IProgressMonitor monitor) {
		for (Entry<IGNATProjectView, LinkedList<IFileStore>> entry : files
				.entrySet()) {

			LinkedList <String> prjCommand = new LinkedList <String> ();

			String[] compile;
			try {
				compile = ToolChain.active().compileCommand(
						entry.getKey().getEclipseProject());
			} catch (NoExtensionFound e1) {
				GNATbenchCorePlugin.getDefault().logError(null, e1);

				continue;
			}

			for (int j = 0; j < compile.length; j++) {
				prjCommand.add(compile [j]);
			}

			prjCommand.addAll (getCommonSuffix(entry.getKey(), entry.getValue()));

			try {
				runProcessInEnv((GPRProject)entry.getKey(), "Ada File(s) Compilation",
						prjCommand.toArray(new String[prjCommand.size()]), entry
								.getKey().getProjectFile().getParent(), monitor);
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}

} // CompileAdaFiles
