/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.filesystem;

import java.util.Comparator;

import org.eclipse.core.resources.IResource;

public class ResourceComparator implements Comparator<IResource> {

	public int compare(IResource o1, IResource o2) {
		return o1.getFullPath().toOSString().compareTo(
				o2.getFullPath().toOSString());
	}
}
