/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.filesystem;

import java.util.Comparator;

import org.eclipse.core.runtime.QualifiedName;

public class NameComparator implements Comparator <QualifiedName> {

	public int compare(QualifiedName arg0, QualifiedName arg1) {
		int result = arg0.getQualifier().compareTo(arg1.getQualifier());

		if (result != 0) {
			return result;
		} else {
			return arg0.getLocalName().compareTo(arg1.getLocalName());
		}
	}

}
