/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.filesystem;

import java.util.TreeMap;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;

public final class FileStoreReference {

	private IResource fRes;
	private IFileStore fStore;
	private boolean fIsProject = false;
	
	private TreeMap <String, Object> fData = new TreeMap <String, Object> ();
	
	public FileStoreReference (IFileStore store, IResource res) {
		fRes = res;
		fStore = store;
	}
	
	public void setProject (boolean value) {
		fIsProject = value;
	}
	
	/**
	 * When this is true, the reference has to be considered as referencing 
	 * an actual project, and not just a file.
	 * 
	 * @return
	 */
	public boolean isProject () {
		return fIsProject;
	}
	
	public IResource getResource() {
		return fRes;
	}

	public IFileStore getFileStore() {
		return fStore;
	}

	public boolean equals (Object element) {
		if (element == this) {
			return true;
		} else if (element instanceof FileStoreReference) {
			FileStoreReference ref = (FileStoreReference) element;

			return getFileStore().equals (ref.getFileStore ());
		}
		
		return false;
	}
	
	/** 
	 * Associate a random piece of data with this store reference
	 */
	public void setData (String key, Object obj) {
		fData.put(key, obj);
	}

	/** 
	 * Return the data associated to the key given in parameter - null if
	 * none.
	 */
	public Object getData (String key) {
		return fData.get(key);
	}
	
	@Override
	public String toString () {
		return fStore.toString();
	}
	
	@Override
	public int hashCode () {
		return getFileStore().hashCode();
	}
}
