/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.filesystem;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;

import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;

public class FileStoreAdapterFactory implements IAdapterFactory{

	@SuppressWarnings("unchecked")
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adaptableObject instanceof IFile
				&& adapterType.isAssignableFrom(GeneralizedFile.class)) {
			return GeneralizedFile.fromWorkspace((IFile) adaptableObject);
		}
		
		return null;
	}

	@SuppressWarnings("unchecked")
	public Class[] getAdapterList() {
		return new Class [] {GeneralizedFile.class};
	}

}
