/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.codingstyle;

/**
 * Recases words in Mixed_Case, but keeps upper-cased letters.
 * 
 * @author ochem
 */
public class SmartMixedCasing implements IAutoCasing {

	public String recase(String word) {
		String result = "";
		boolean upper = true;

		for (int i = 0; i < word.length(); ++i) {
			char c = word.charAt(i);

			if (c == '_') {
				upper = true;
			} else if (upper) {
				if (c >= 'a' && c <= 'z') {
					c = (char) (c - 'a' + 'A');
				}

				upper = false;
			} else {
				//  Don't do anything for uppercase
			}

			result += c;
		}

		return result;
	}

}
