/*******************************************************************************
 * Copyright (c) 2006, 2009 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.builder;

import org.eclipse.core.runtime.IProgressMonitor;

/**
 * This class has to be implemented by clients who want to listen to results
 * of GNATbench compilations.
 */
public interface IGNATbenchBuildListener {

	/**
	 * Called after a compilation process has been done.
	 *
	 * @param event
	 * @param monitor
	 */
	public void compilationCompleted(CompilationEvent event,
			IProgressMonitor monitor);
}
