/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.GNATbenchProjectProperties;

/**
 * This is the nature of a GNATbench project.
 */
public class GNATbenchProjectNature implements IProjectNature {

	public final static String NATURE_ID = GNATbenchCorePlugin.getId()
			+ ".GNATbenchProjectNature";

	private IProject fProject;

	public void configure() throws CoreException {
		GNATbenchProjectProperties props = GNATbenchProjectProperties
				.getPropertiesFor(fProject);
	    props.setRootProject(true);
	    props.saveProjectFile();

	    //  send the signal to all contributions

	    IExtensionRegistry er = Platform.getExtensionRegistry();
		IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(),
				"natureContribution");

		IExtension[] extensions = ep.getExtensions();

		if (extensions.length == 0) {
			return;
		}

		for (int extInd = 0; extInd < extensions.length; ++extInd) {

			IConfigurationElement[] elements = extensions[extInd]
					.getConfigurationElements();

			for (int i = 0; i < elements.length; ++i) {
				if (elements[i].getName().equals("contribution")) {
					try {
						Bundle bundle = Platform.getBundle(extensions[extInd]
								.getNamespaceIdentifier());

						IGNATbenchProjectNatureContribution contrib  =
							(IGNATbenchProjectNatureContribution) bundle
								.loadClass(
										elements[i]
												.getAttribute("class"))
								.newInstance();

						contrib.configure(fProject);
					} catch (InvalidRegistryObjectException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (InstantiationException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (IllegalAccessException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (ClassNotFoundException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					}
				}
			}
		}
	}

	public void deconfigure() throws CoreException {
	}

	public IProject getProject() {
		return fProject;
	}

	public void setProject(IProject project) {
		fProject = project;
	}

	/**
	 * Adds a GNATbench nature to the project given in parameter if there
	 * aren't any yet. Otherwise, do nothing.
	 *
	 * @param project
	 * @throws CoreException
	 */
	static public void addNature (IProject project) throws CoreException {
		 if (!project.hasNature(NATURE_ID)) {
			 IProjectDescription description = project.getDescription();

			 String [] natures = description.getNatureIds();
			 String [] newNatures = new String [natures.length + 1];

			 System.arraycopy (natures, 0, newNatures, 0, natures.length);
			 newNatures [natures.length] = NATURE_ID;
			 description.setNatureIds(newNatures);
			 project.setDescription(description, null);
		 }
	}

}
