/*****************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.IProgressMonitor;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class ConsolePrinter extends Thread {
	private InputStream fIs;
	private ArrayList <String>rawMessages = new ArrayList<String>();
	private IProgressMonitor currentMonitor;
	private BuildConsole fConsole;

	private final static String progressMessageFormat =
		"completed ([0-9]+) out of ([0-9]+) \\(([^\\n]*)%\\)\\.\\.\\.";

	private final Pattern progressMessage =
		Pattern.compile(progressMessageFormat, Pattern.CASE_INSENSITIVE);

	public ConsolePrinter(InputStream is, IProgressMonitor activeMonitor, BuildConsole console) {
		fIs = is;
		currentMonitor = activeMonitor;
		fConsole = console;
	} // ctor

	@Override
	public void run() {
		int previousWorked = 0;
		int currentWorked = 0;
		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(fIs));
			String line = null;

			while ((line = br.readLine()) != null) {
				Matcher progressPattern = progressMessage.matcher(line);

				if (progressPattern.matches()) {
					// gnatmake is giving us absolute completion percentages,
					// but the monitor expects the delta. note also that
					// the percentage reported by gnatmake may decrease as
					// new files to be compiled are discovered; this is OK.
					currentWorked = Integer.parseInt(progressPattern.group(3));
					currentMonitor.worked(currentWorked - previousWorked);
					previousWorked = currentWorked;
				} else {
					fConsole.print(line + "\n");
					rawMessages.add(line);
				} // if
			} // while
		} catch (IOException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try
	} // run

	public String [] getMessages() {
		String [] result;
		if (rawMessages.isEmpty()) {
			result = new String[1];
			result[0] = "";
			return result;
		} // if
		rawMessages.trimToSize();
        result = new String[rawMessages.size()];
		int index = 0;
		for (String element : rawMessages) {
			result [index] = element;
			index = index + 1;
		} // for
		return result;
	} // getMessages

}
