/*****************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal.builder;

import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.internal.jobs.ToolMessage;

public class CompilationEvent {
	/**
	 * Project on which the compilation occured.
	 */
	public IProject project;

	/**
	 * List of the messages that have been generated by this event.
	 */
	public String[] messages;

	/**
	 * Root class of the messages that may be generated by this event.
	 *
	 * @see ToolMessage
	 */
	public Class <? extends ToolMessage> rootMessageClass;

	/**
	 * If this flag is false, then the compilation event should not open any
	 * view, e.g. we are in auto-build mode.
	 */
	public boolean raiseViews = true;
}
