/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.builder;

import java.io.IOException;

import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.part.IPageBookViewPage;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class BuildConsole extends IOConsole {

	TextConsolePage fPage;
	IOConsoleOutputStream fOutputStream = null;
	String fWaitingText = "";


	public BuildConsole(String name) {
		super(name, null, null, true);
	} // ctor


	public IPageBookViewPage createPage(IConsoleView view) {
		fPage = (TextConsolePage) super.createPage(view);
		return fPage;
	} // createPage


	protected String getWaitingText () {
		synchronized (this) {
			String tmp = fWaitingText;
			fWaitingText = "";

			return tmp;
		}
	} // getWaitingText


	protected void addWaitingText (String str) {
		synchronized (this) {
			fWaitingText = fWaitingText + str;
		}
	} // addWaitingText


	public void print(String text) {
		addWaitingText(text);
		IOConsoleOutputStream stream = newOutputStream();

		try {
			stream.write(getWaitingText());
			stream.close();
		} catch (IOException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	} // print


} // BuildConsole
