/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.builder;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;

public class AdaBuilderPreferencesProvider 
	implements IGNATbenchPreferencesProvider {
	
	public final static String ADA_SAVE_DIRTY_ON_BUILD =  
		GNATbenchCorePlugin.getId() + ".save_on_build";
	
	public void createPreferenceFields (AdaPreferencePage page) {
		page.addField(new BooleanFieldEditor(
				ADA_SAVE_DIRTY_ON_BUILD, 
				"Save altered files before compilation",
				page.getFieldEditorParent()));
	} // createPreferenceFields

	public void initializeDefaultPreferences (IPreferenceStore store) {
		store.setDefault(ADA_SAVE_DIRTY_ON_BUILD, true);
	} // initializeDefaultPreferences


	public void okPerformed (AdaPreferencePage page) {
		// TODO Auto-generated method stub		
	} // okPerformed

} // AdaBuilderPreferencesProvider
